% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{draw.dates}
\alias{draw.dates}
\title{add calibrated distributions to a plot.}
\usage{
draw.dates(
  age,
  error,
  depth,
  cc = 1,
  postbomb = FALSE,
  reservoir = c(),
  normal = TRUE,
  t.a = 3,
  t.b = 4,
  prob = 0.95,
  threshold = 0.001,
  BCAD = FALSE,
  ex = 0.9,
  normalise = TRUE,
  draw.hpd = TRUE,
  hpd.lwd = 2,
  hpd.col = rgb(0, 0, 1, 0.7),
  mirror = TRUE,
  up = FALSE,
  on.axis = 1,
  col = rgb(0, 0, 1, 0.3),
  border = rgb(0, 0, 1, 0.5),
  add = FALSE,
  cal.lab = c(),
  cal.lim = c(),
  y.lab = c(),
  y.lim = c(),
  y.rev = TRUE,
  labels = c(),
  label.x = 1,
  label.y = c(),
  label.cex = 0.8,
  label.col = border,
  label.offset = c(0, 0),
  label.adj = c(1, 0),
  label.rot = 0,
  ccdir = NULL,
  ...
)
}
\arguments{
\item{age}{Mean of the uncalibrated C-14 age (or multiple ages).}

\item{error}{Error of the uncalibrated C-14 age (or ages).}

\item{depth}{Depth(s) of the date(s)}

\item{cc}{Calibration curve for C-14 dates (1, 2, 3, or 4, or, e.g., "IntCal20", "Marine20", "SHCal20", "nh1", "sh3", or "mixed"). If there are multiple dates but all use the same calibration curve, one value can be provided.}

\item{postbomb}{Whether or not this is a postbomb age. Defaults to FALSE.}

\item{reservoir}{Reservoir age, or reservoir age and age offset.}

\item{normal}{Use the normal distribution to calibrate dates (default TRUE). The alternative is to use the t model (Christen and Perez 2016).}

\item{t.a}{Value a of the t distribution (defaults to 3).}

\item{t.b}{Value a of the t distribution (defaults to 4).}

\item{prob}{Probability confidence intervals (between 0 and 1).}

\item{threshold}{Report only values above a threshold. Defaults to \code{threshold=0.001}.}

\item{BCAD}{Use BC/AD or cal BP scale (default cal BP).}

\item{ex}{Exaggeration of the height of the distribution}

\item{normalise}{If TRUE, the date is normalised by setting its peak value to 1 (handy for estimating how high to draw it). If there are multiple dates, it is normalised to the peak of the most precise date. Otherwise the peak of each date is at the same height.}

\item{draw.hpd}{Whether or not to draw the hpd ranges as a line}

\item{hpd.lwd}{Width of the line of the hpd ranges}

\item{hpd.col}{Colour of the hpd rectangle}

\item{mirror}{Plot distributions mirrored, a bit like a swan. Confuses some people but looks nice to the author so is the default.}

\item{up}{If mirror is set to FALSE, the distribution can be plotted up or down, depending on the direction of the axis.}

\item{on.axis}{Which axis to plot on. Defaults to 'x' or 1, but can be set to 'y' or 2.}

\item{col}{Colour of the inside of the distribution}

\item{border}{Colour of the border of the distribution}

\item{add}{Whether or not to add the dates to an existing plot. If set to FALSE (default), a plot will be set up.}

\item{cal.lab}{Title of the calendar axis (if present)}

\item{cal.lim}{Limits of the calendar axis (if present)}

\item{y.lab}{Title of the vertical axis (if present)}

\item{y.lim}{Limits of the vertical axis (if present)}

\item{y.rev}{Reverse the y-axis. Defaults to TRUE}

\item{labels}{Add labels to the dates. Empty by default.}

\item{label.x}{Horizontal position of the date labels. By default draws them before the youngest age (1), but can also draw them after the oldest age (2), or above its mean (3).}

\item{label.y}{Vertical positions of the labels. Defaults to 0 (or 1 if label.x is 3 or 4).}

\item{label.cex}{Size of labels.}

\item{label.col}{Colour of the labels. Defaults to the colour given to the borders of the dates.}

\item{label.offset}{Offsets of the positions of the labels, giving the x and y offsets. Defaults to c(0,0).}

\item{label.adj}{Justification of the labels. Follows R's adj option: A value of ‘0’ produces left-justified text, ‘0.5’ (the default) centered text and ‘1’ right-justified text.}

\item{label.rot}{Rotation of the label. 0 by default (horizontal).}

\item{ccdir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{ccdir="curves"}.}

\item{...}{Additional plotting options}
}
\value{
A plot of the (calibrated) dates
}
\description{
Add individual calibrated dates to a plot.
}
\examples{
  plot(0, xlim=c(500,0), ylim=c(0, 2))
  draw.dates(130, 20, depth=1) 
}
