% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_inat_obs.R
\name{get_inat_obs}
\alias{get_inat_obs}
\title{Download iNaturalist data}
\usage{
get_inat_obs(
  query = NULL,
  taxon_name = NULL,
  taxon_id = NULL,
  place_id = NULL,
  quality = NULL,
  geo = NULL,
  year = NULL,
  month = NULL,
  day = NULL,
  bounds = NULL,
  maxresults = 100,
  meta = FALSE
)
}
\arguments{
\item{query}{Query string for a general search.}

\item{taxon_name}{Filter by iNat taxon name. Note that this will also select observations of
descendant taxa. Note that names are not unique, so if the name matches multiple taxa, no
observations may be returned.}

\item{taxon_id}{Filter by iNat taxon ID. Note that this will also select observations of descendant taxa.}

\item{place_id}{Filter by iNat place ID.}

\item{quality}{The quality grade to be used.  Must be either "casual" or "research".  If left
blank both will be returned.}

\item{geo}{Flag for returning only results that are georeferenced, TRUE will exclude
non-georeferenced results, but they cannot be excluded.}

\item{year}{Return observations only in that year (can only be one year, not a range of years).}

\item{month}{Return observations only by month, must be numeric, 1...12}

\item{day}{Return observations only on a given day of the month,  1...31}

\item{bounds}{A bounding box of longitude (-180 to 180) and latitude (-90 to 90) to search
within.  It is a vector in the form of southern latitude, western longitude, northern latitude,
and eastern longitude. Alternatively supply an sf or sp object from which the bounding box will
be derived.}

\item{maxresults}{The maximum number of results to return. Should not be
a number higher than 10000.}

\item{meta}{(logical) If TRUE, the output of this function is a list with metadata on the output
and a data.frame of the data. If FALSE (default), just the data.frame.}
}
\value{
A dataframe of the number of observations requested.
}
\description{
Primary function to retrieve observations from iNaturalist, allows users to search
for data, or just filter results by a subset of what is offered by the API.
}
\note{
Filtering doesn't always work with the query parameter for some reason (a problem on
the API end).  If you want to filter by time, it's best to use the scientific name and put it
in the 'taxa' field, and not in the query field.  Another issue is that the query parameter
will search the entire entry, so it is possible to get unintended results.  Depending on your
use case it may be advisable to use the "taxon" field instead of the query field.
}
\examples{
\dontrun{
  ### Make a standard query
  get_inat_obs(query = "Monarch Butterfly")

  ##Filter by a bounding box of Northern California
  bounds <- c(38.44047, -125, 40.86652, -121.837)
  get_inat_obs(query = "Mule Deer", bounds = bounds)

  ## Filter with by just taxon, allows higher order filtering,
  ## Here we can search for just stone flies (order Plecoptera)
  get_inat_obs(taxon_name = "Plecoptera")

  ## get metadata (the number of results found on the server)
  out <- get_inat_obs(query = "Monarch Butterfly", meta = TRUE)
  out$meta
}
}
