% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rice.R
\name{generate_passphrase}
\alias{generate_passphrase}
\title{Generates a passphrase}
\usage{
generate_passphrase(tokens = generate_token(7), verbose = TRUE, ...)
}
\arguments{
\item{tokens}{a vector of character representing the tokens to be
used to generate the passphrase. By default, 7 are randomly
generated using \code{generate_token(7)}.}

\item{verbose}{if \code{TRUE} the passphrase is displayed as a message}

\item{...}{additional parameters to be passed to \code{\link{match_token}}}
}
\value{
a character string representing the passphrase
}
\description{
Generates a passphrase.
}
\details{
Given a wordlist and a number of words, this function generates a
passphrase. You can control the wordlist you choose and whether
the passphrase uses title case by providing additional arguments
that will be passed to \code{\link{match_token}}.
}
\examples{
generate_passphrase(tokens = generate_token(7, "pseudorandom"),
                      verbose = FALSE)
}
\author{
Francois Michonneau
}
\seealso{
\code{\link{match_token}}, \code{\link{generate_token}}
}

