% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinship.R
\name{kinship}
\alias{kinship}
\title{Kinship coefficients}
\usage{
kinship(x, ids = NULL, simplify = TRUE, Xchrom = FALSE)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{ids}{Either NULL (default), or a vector of ID labels in \code{x}.}

\item{simplify}{A logical. by default TRUE. See Value.}

\item{Xchrom}{A logical, indicating if the autosomal (default) or
X-chromosomal kinship coefficients should be computed.}
}
\value{
A symmetric N * N matrix, where N is the number of pedigree members,
or \code{length(ids)} if this is given, containing the pairwise kinship
coefficients. If \code{ids} has length 2, and \code{simplify = TRUE}, the function
returns a single number.
}
\description{
Compute the matrix of pairwise kinship coefficients in a pedigree. Both
autosomal and X-chromosomal versions are supported. The pedigree founders are
allowed to be inbred; see \code{\link[pedtools:founderInbreeding]{pedtools::founderInbreeding()}} for how to set this
up, and see Examples below.
}
\details{
For two (possibly equal) members A, B of a pedigree, their autosomal (resp.
X-chromosomal) \emph{kinship coefficient} is defined as the probability that a
random allele from A and a random allele from B, sampled at the same
autosomal (resp. X-chromosomal) locus, are identical by descent relative to
the pedigree.
}
\examples{
# Kinship coefficients in a nuclear family with two children
x = nuclearPed(2)
kinship(x)

# X chromosomal kinship coefficients in the same family
kinship(x, Xchrom = TRUE)

# Autosomal kinships if the mother is 100\% inbred
founderInbreeding(x, 2) = 1
kinship(x)

# Similar for X:
founderInbreeding(x, 2, chromType = "X") = 1
kinship(x, Xchrom = TRUE)
}
\seealso{
\code{\link[=inbreeding]{inbreeding()}}, \code{\link[=kappa]{kappa()}}
}
