% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rhandsontable.R
\name{hot_validate_character}
\alias{hot_validate_character}
\title{Handsontable widget}
\usage{
hot_validate_character(hot, cols, choices, allowInvalid = FALSE)
}
\arguments{
\item{hot}{rhandsontable object}

\item{cols}{vector of column names or indices}

\item{choices}{a vector of acceptable numeric choices. It will be evaluated
after min and max if specified.}

\item{allowInvalid}{logical specifying whether invalid data will be
accepted. Invalid data cells will be color red.}
}
\description{
Add numeric validation to a column
}
\examples{
library(rhandsontable)
DF = data.frame(val = 1:10, bool = TRUE, big = LETTERS[1:10],
                small = letters[1:10],
                dt = seq(from = Sys.Date(), by = "days", length.out = 10),
                stringsAsFactors = FALSE)

rhandsontable(DF) \%>\%
  hot_validate_character(col = "big", choices = LETTERS[1:10])
}
\seealso{
\code{\link{hot_validate_numeric}}
}

