% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form-edits.R
\name{create_multiple_choice_question}
\alias{create_multiple_choice_question}
\title{Create a multiple choice question}
\usage{
create_multiple_choice_question(
  form_id = NULL,
  commit_to_form = TRUE,
  required = FALSE,
  question = NULL,
  choice_vector = NULL,
  shuffle_opt = FALSE,
  correct_answer = NULL,
  google_forms_request = NULL,
  point_value = 1,
  quiet = FALSE,
  location = 0
)
}
\arguments{
\item{form_id}{The id of the google form to be updated}

\item{commit_to_form}{Whether or not the request should be committed. If need to build the request further, you will want to say FALSE. Default is TRUE}

\item{required}{TRUE or FALSE is this a required question? Default is not required.}

\item{question}{a string that is what the question should say}

\item{choice_vector}{a character vector of the choices that should be given for this question}

\item{shuffle_opt}{TRUE or FALSE options should be shuffled? default is FALSE}

\item{correct_answer}{The index that corresponds to the correct answer in the `choice_vector` supplied}

\item{google_forms_request}{A google forms request object. If not supplied, it will be created new.}

\item{point_value}{An integer representing how many points}

\item{quiet}{TRUE/FALSE you'd like a progress message?}

\item{location}{Where should the new question be added}
}
\description{
Create a multiple choice question
}
\examples{
\dontrun{

create_multiple_choice_question(
  form_id = "12345",
  question = "What answer do you want?",
  choice_vector = c("A", "B", "C", "D"),
  correct_answer = 3,
  shuffle_opt = TRUE
)
}
}
