% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gads_keyword_plan_historical_metrics.R
\name{gads_keyword_plan_historical_metrics}
\alias{gads_keyword_plan_historical_metrics}
\title{Returns the requested Keyword Plan historical metrics.}
\usage{
gads_keyword_plan_historical_metrics(
  keyword_plan_id,
  customer_id = getOption("gads.customer.id"),
  login_customer_id = getOption("gads.login.customer.id"),
  verbose = TRUE
)
}
\arguments{
\item{keyword_plan_id}{Keyword plan id, you can get list of your keyword plans using \code{\link{gads_get_report}} with recource keyword_plan}

\item{customer_id}{Google Ads client customer id, supports a single account id: "xxx-xxx-xxxx" or a vector of ids from the same Google Ads MCC: c("xxx-xxx-xxxx", "xxx-xxx-xxxx")}

\item{login_customer_id}{Google Ads manager customer id}

\item{verbose}{Console log output}
}
\value{
tibble with keyword plan historical metrics
}
\description{
Returns the requested Keyword Plan historical metrics.
}
\examples{
\dontrun{
# set client id
gads_set_customer_id('xxx-xxx-xxxx')

# set manager id
gads_set_login_customer_id('xxx-xxx-xxxx')

# get list of plan
plan_data <- gads_get_report(
  resource = 'keyword_plan',
  fields = c('keyword_plan.id')
)

# get keyword historical data
historical_plan_data <- gads_keyword_plan_historical_metrics(
 keyword_plan_id = plan_data$keyword_plan_id[1]#'
)

# main plan data
data <- historical_plan_data$main_data
historical_data <- historical_plan_data$historical_data

}
}
