% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deprecated.R
\name{Ops-methods}
\alias{Ops-methods}
\alias{Ops.ee.image.Image}
\title{Earth Engine arithmetic, logic and compare generic functions}
\usage{
\method{Ops}{ee.image.Image}(e1, e2)
}
\arguments{
\item{e1}{Numeric or ee$Image.}

\item{e2}{Numeric or ee$Image.}
}
\description{
Arithmetic, logic and compare operators for computation with \code{ee$Image}
objects and numeric values.
}
\details{
\itemize{
\item \strong{Arith}: +, -, *, /, ^, \%\%, \%/\%, \%>>\% and \%>>\%.
\item \strong{Logic}: !, &, |.
\item \strong{Comparison}: ==, !=, >, <, <=, >=
}
}
\examples{
\dontrun{
library(rgee)
ee_Initialize()

# Sum Operator
ee1 <- ee$Image(1)
ee2 <- ee$Image(2)
ee3 <- ee1 + ee2
ee_extract(ee3, ee$Geometry$Point(0, 0))

v1 <- 1
v2 <- 2
v3 <- v1 + v2
v3

# Multiple Operators
ee4 <- ee1 / 10
ee5 <- ee4 * (ee2 - 1 + ee1^2 / ee2)
ee_extract(ee5, ee$Geometry$Point(0, 0))

v4 <- v1 / 10
v5 <- v4 * (v2 - 1 + v1^2 / v2)
v5

# multi-layer object mutiplication, no recycling
ee6 <- ee1 + c(1, 5, 10)
ee_extract(ee6, ee$Geometry$Point(0, 0))

v6 <- v1 + c(1, 5, 10)
v6
}
}
