% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-statistics.R
\name{cov.pop}
\alias{cov.pop}
\title{Population Covariance}
\usage{
cov.pop(x, y)
}
\arguments{
\item{x}{a ml.data.frame field.}

\item{y}{a ml.data.frame field}
}
\value{
The population covariance
}
\description{
Returns the population covariance of two variables, \link{ml.data.frame} fields.
}
\details{
The function eliminates all pairs for which either the first element or the
second element is empty. After the elimination, if the length of the input is 0,
the function returns the empty sequence.
}
\examples{
\dontrun{
 library(rfml)
 locConn <- ml.connect()
 # create a ml.data.frame based on a search
 mlIris <- ml.data.frame(locConn, collection = "iris")
 # return the population covariance
 cov.pop(mlIris$Sepal.Length, mlIris$Petal.Length)
}
}

