% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexscan.R
\docType{package}
\name{rflexscan-package}
\alias{rflexscan-package}
\title{Analyze spatial count data using the flexible spatial scan statistic}
\description{
The rflexscan package provides functions and classes to analyze spatial count
data using the flexible spatial scan statistic developed by Tango and 
Takahashi (2005). This package designed for any of the following interrelated
 purposes:
\enumerate{
  \item To evaluate reported spatial disease clusters, to see if they are 
        statistically significant.
  \item To test whether a disease is randomly distributed over space.
  \item To perform geographical surveillance of disease, to detect areas of 
        significantly high rates.
}
This package implements a wrapper for the C routine used in the FleXScan 3.1.2 
developed by Takahashi, Yokoyama, and Tango.
}
\references{
\itemize{
  \item Tango T. and Takahashi K. (2005). A flexibly shaped spatial scan 
  statistic for detecting clusters, International Journal of Health
  Geographics 4:11.
  \item Takahashi K, Yokoyama T and Tango T. (2010). FleXScan v3.1: Software 
  for the Flexible Scan Statistic. National Institute of Public Health, Japan,
  \url{https://sites.google.com/site/flexscansoftware/home}.
}
}
\seealso{
\code{\link{rflexscan}}
}
