% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf.combine.R
\name{rf.combine}
\alias{rf.combine}
\title{Combine Random Forests Ensembles}
\usage{
rf.combine(...)
}
\arguments{
\item{...}{two or more randomForest class objects}
}
\value{
An object of class randomForest
}
\description{
Combine two more more random forests models into a single ensemble.
}
\note{
The confusion, err.rate, mse and rsq components (as well as the corresponding components in the test component, if exist) are averaged across ensembles

This is a modification of the randomForest \code{\link[randomForest]{combine}} function that returns averaged validation statistics
}
\examples{
library(randomForest)
data(iris)

c1 <- randomForest(Species ~ ., iris, ntree=50, norm.votes=FALSE)
c2 <- randomForest(Species ~ ., iris, ntree=50, norm.votes=FALSE)
c3 <- randomForest(Species ~ ., iris, ntree=50, norm.votes=FALSE)

( class.combine <- rf.combine(c1,c2,c3) )

data(airquality)
set.seed(131)
r1 <- randomForest(Ozone ~ ., data=airquality, mtry=3,
                   importance=TRUE, na.action=na.omit)
r2 <- randomForest(Ozone ~ ., data=airquality, mtry=3,
                   importance=TRUE, na.action=na.omit)
r3 <- randomForest(Ozone ~ ., data=airquality, mtry=3,
                   importance=TRUE, na.action=na.omit)

( regress.combine <- rf.combine(r1,r2,r3) )				   

}
\seealso{
\code{\link[randomForest]{randomForest}} for randomForest details

\code{\link[randomForest]{combine}} for original combine function details
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
