% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/eutil.R
\docType{methods}
\name{rettype}
\alias{rettype}
\alias{rettype,eutil-method}
\title{rettype}
\usage{
rettype(x, ...)

\S4method{rettype}{eutil}(x, ...)
}
\arguments{
\item{x}{An \code{\linkS4class{eutil}} object.}

\item{...}{Further arguments passed on to methods.}
}
\value{
A character string.
}
\description{
Get the \dQuote{retrieval type} of an \code{\linkS4class{eutil}} object. See
\href{http://www.ncbi.nlm.nih.gov/books/NBK25499/table/chapter4.T._valid_values_of__retmode_and/?report=objectonly}{here}
for the available retrieval types for different NCBI databases.
}
\section{Methods (by class)}{
\itemize{
\item \code{eutil}: 
}}
\examples{
\dontrun{
e <- esearch("Mus musculus", "taxonomy")
rettype(e)
}
}
\seealso{
\code{\link{einfo}}, \code{\link{esearch}}, \code{\link{esummary}},
   \code{\link{efetch}}, \code{\link{elink}}, \code{\link{epost}},
   \code{\link{egquery}}, \code{\link{espell}}, \code{\link{ecitmatch}}.
}

