% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_python.R
\name{conda-tools}
\alias{conda-tools}
\alias{conda_list}
\alias{conda_create}
\alias{conda_remove}
\alias{conda_install}
\alias{conda_binary}
\alias{conda_version}
\title{Interface to conda utility commands}
\usage{
conda_list(conda = "auto")

conda_create(envname, packages = "python", conda = "auto")

conda_remove(envname, packages = NULL, conda = "auto")

conda_install(envname, packages, pip = FALSE, pip_ignore_installed = TRUE,
  conda = "auto")

conda_binary(conda = "auto")

conda_version(conda = "auto")
}
\arguments{
\item{conda}{Path to conda executable (or "auto" to find conda using the PATH
and other conventional install locations).}

\item{envname}{Name of conda environment}

\item{packages}{Character vector with package names to install.}

\item{pip}{\code{TRUE} to use pip (defaults to \code{FALSE})}

\item{pip_ignore_installed}{Ignore installed versions when using pip. This is \code{TRUE} by default
so that specific package versions can be installed even if they are downgrades. The \code{FALSE}
option is useful for situations where you don't want a pip install to attempt an overwrite
of a conda binary package (e.g. SciPy on Windows which is very difficult to install via
pip due to compilation requirements).}
}
\value{
\code{conda_list()} returns a data frame with the names and paths to the
respective python binaries of available environments. \code{conda_create()}
returns the Path to the python binary of the created environment.
\code{conda_binary()} returns the location of the main conda binary or \code{NULL}
if none can be found.
}
\description{
Interface to conda utility commands
}
\keyword{intername}
