% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_toc.R
\name{extract_toc}
\alias{extract_toc}
\title{Extract the text of the table of contents from SDMX XML}
\usage{
extract_toc(ns)
}
\arguments{
\item{ns}{an XML node set from the XML TOC file}
}
\value{
a character vector with all the values of the node set.
}
\description{
Extracts the values of a node from the Eurostat XML Table of contents (TOC) file
}
\details{
It is a sub-function to use in the \code{\link{get_eurostat_toc}} function.
}
\examples{
\dontshow{
if (parallel::detectCores()<=2){
   options(restatapi_cores=1)
}else{
   options(restatapi_cores=2)
}    
}
cfg<-get("cfg",envir=restatapi::.restatapi_env) 
rav<-get("rav",envir=restatapi::.restatapi_env)
toc_endpoint<-eval(parse(text=paste0("cfg$TOC_ENDPOINT$'",rav,"'$ESTAT$xml")))
\donttest{
options(timeout=2)
xml_leafs<-xml2::xml_find_all(xml2::read_xml(toc_endpoint),".//nt:leaf")
restatapi::extract_toc(xml_leafs[1])
options(timeout=60)
}

}
