% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rp_save2csv.R
\name{rp.save2csv}
\alias{rp.save2csv}
\title{Export indices into a CSV file}
\usage{
rp.save2csv(
  rp.object,
  file = "rp_results.csv",
  csv = c("csv", "csv2"),
  include.coefs = TRUE,
  include.data = TRUE
)
}
\arguments{
\item{rp.object}{A ResponsePatterns object.}

\item{file}{A string. A filename or a path.}

\item{csv}{A string. Specify the CSV file format.}

\item{include.coefs}{A logical scalar. Should the exported file include the coefficients?}

\item{include.data}{A logical scalar. Should the exported file include the data?}
}
\value{
Exports a CSV file.
}
\description{
This functions exports the ResponsePatterns object indices and, optionally, coefficients and data.
}
\examples{
rp <- rp.acors(rp.simdata, id.var="optional_ID")
\dontrun{rp.save2csv(rp)}
\dontrun{rp.save2csv(rp, include.coefs=FALSE, include.data=FALSE)}
}
\seealso{
\code{\link{rp.acors}}, \code{\link{rp.patterns}}, \code{\link{rp.indices}}
}
