% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{opls_get_all}
\alias{opls_get_all}
\title{orthogonal scores algorithn of partial leat squares (opls_get_all)}
\usage{
opls_get_all(X, 
             Y, 
             ncomp, 
             scale, 
             maxiter, 
             tol)
}
\arguments{
\item{X}{a matrix of predictor variables.}

\item{Y}{a matrix of either a single or multiple response variables.}

\item{ncomp}{the number of pls components.}

\item{scale}{logical indicating whether \code{X} must be scaled.}

\item{maxiter}{maximum number of iterations.}

\item{tol}{limit for convergence of the algorithm in the nipals algorithm.}
}
\value{
a list containing the following elements:
\itemize{
\item{\code{ncomp}}{ the number of components used.}
\item{\code{coefficients}}{ the matrix of regression coefficients.}
\item{\code{bo}}{ a matrix of one row containing the intercepts for each component.}
\item{\code{scores}}{ the matrix of scores.}
\item{\code{X_loadings}}{ the matrix of X loadings.}
\item{\code{Y_loadings}}{ the matrix of Y loadings.}
\item{\code{vip}}{ the projection matrix.}
\item{\code{selectivity_ratio}}{ the matrix of selectivity ratio (see Rajalahti, Tarja, et al. 2009).}
\item{\code{Y}}{ the \code{Y} input.}
\item{\code{variance}}{ a \code{list} conating two objects: \code{x_var} and \code{y_var}. 
These objects contain information on the explained variance for the \code{X} and \code{Y} matrices respectively.}
\item{\code{transf}}{ a \code{list} conating two objects: \code{Xcenter} and \code{Xscale}}. 
\item{\code{weights}}{ the matrix of wheights.}}
}
\description{
Computes orthogonal socres partial least squares (opls_get_all) 
regressions with the NIPALS algorithm. It retrives a comprehensive set of
pls outputs (e.g. vip and sensivity radius). It allows multiple response 
variables. NOTE: For internal use only!
}
\author{
Leonardo Ramirez-Lopez
}
\keyword{internal}
