% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_time.R
\name{convert_time}
\alias{convert_time}
\title{Convert a UDUNITS compatible time to ISO time}
\usage{
convert_time(n = NULL, isoTime = NULL,
  units = "seconds since 1970-01-01T00:00:00Z", url = eurl(),
  method = "local", ...)
}
\arguments{
\item{n}{numeric; A unix time number.}

\item{isoTime}{character; A string time representation.}

\item{units}{character; Units to return. Default:
"seconds since 1970-01-01T00:00:00Z"}

\item{url}{Base URL of the ERDDAP server. See \code{\link[=eurl]{eurl()}} for
more information}

\item{method}{(character) One of local or web. Local simply uses
\code{\link[=as.POSIXct]{as.POSIXct()}}, while web method uses the ERDDAP time conversion service
\code{/erddap/convert/time.txt}}

\item{...}{Curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Convert a UDUNITS compatible time to ISO time
}
\details{
When \code{method = "web"} time zone is GMT/UTC
}
\examples{
 \dontrun{
# local conversions
convert_time(n = 473472000)
convert_time(isoTime = "1985-01-02T00:00:00Z")

# using an erddap web service
convert_time(n = 473472000, method = "web")
convert_time(isoTime = "1985-01-02T00:00:00Z", method = "web")
}
}
