% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_setup.R
\name{cache_setup}
\alias{cache_setup}
\alias{cache_info}
\title{Setup cache path}
\usage{
cache_setup(path_suffix = NULL)

cache_info()
}
\arguments{
\item{path_suffix}{(character) the path suffix to be use for storing
cached files}
}
\value{
the full cache path, a directory (character)
}
\description{
Setup cache path
}
\details{
Looks first if the user has set a cache path suffix in an
env var or R option. If not found, proceeds to use a temp directory
if not in interactive mode, but if interactive, asks user to setup a
default cache location that will work across sessions (but user can say
no, in which case a temp directory will be used, and each package
start will require cache setup again)
}
\examples{
\dontrun{
# default path
cache_setup()

# you can define your own path
cache_setup(path = "foobar")

# cache info
cache_info()
}
}
\seealso{
Other cache: \code{\link{cache_delete}},
  \code{\link{cache_details}}, \code{\link{cache_list}}
}
