% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clust_proto.R
\name{clust_proto_random}
\alias{clust_proto_random}
\alias{clust_proto_minimax}
\title{Prototype record from a cluster.}
\usage{
clust_proto_random(
  cluster,
  prob = rep(1/nrow(cluster), nrow(cluster)),
  id = TRUE
)

clust_proto_minimax(cluster, distance, id = TRUE, ...)
}
\arguments{
\item{cluster}{A data frame of the clustered records.}

\item{prob}{A vector of length \code{nrow(cluster)} that sums to 1, giving the probability of selection.}

\item{id}{Logical indicator to return id of record selected (TRUE) or actual record (FALSE). Note,
if returning id, must have original row numbers as rownames in each cluster.}

\item{distance}{A distance function for comparing records}

\item{...}{Additional arguments passed to the comparison function}
}
\value{
If \code{id = FALSE}, returns the prototype record from an individual cluster. Otherwise,
    returns the record id of the prototype record for that cluster. If there is a tie in the minimax
    prototype method, then random selection is used to break the tie.
}
\description{
Prototype record from a cluster.
}
\examples{
data("rl_reg1")

clusters <- split(rl_reg1, identity.rl_reg1)
clust_proto_random(clusters[[1]])


clust_proto_minimax(clusters[[1]], dist_binary)

}
