% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/help.R
\docType{data}
\name{repra.data}
\alias{repra-data}
\alias{repra.data}
\alias{repraareas}
\alias{repracapacity}
\alias{repradata}
\alias{repragen}
\alias{repratime}
\title{Generator and time series data sets}
\description{
\code{repra} includes sample data to showcase typical calculations. This data is contained in four
data frames called \code{repratime}, \code{repragen}, \code{repraareas}, \code{repra capacity}. The
data was adapted from the Western Electricity Coordinating Council's (WECC) Transmission Expansion
Planning Policy Committee (TEPPC) 2024 Common Case (version 1.0). The data should be considered only
for illustrative purposes and no conclusions should be made based on it.
}
\details{
The data is presented for 8 regions in the Western Interconnection: Alberta, AZ-NM-NV (Arizona-New
Mexico-Nevada), Basin, British Columbia, California North and South, NWPP (Northwest Power Pool), and
RMPA (Rocky Mountain Power Authority). It is presented through four data frames, which are described
in the following paragraphs.

\code{repratime} includes the load, wind, PV and CSP time series for the eight regions.

\code{repragen} includes the name, nameplate capacity, expected forced outage rate (EFOR) and area for
all the generators (that are not wind, PV or CSP).

\code{repraareas} includes a little example of how the eight areas can be aggregated up to the
interconnection level.

Finally, \code{repracapacities} summarize the installed capacities for wind, PV and CSP (which are
useful to normalize capacity value, for example).
}
\references{
Western Electricity Coordinating Council (2014). Transmission Expansion
  Planning Policy Committee (TEPPC) 2024 Common Case (version 1.0).
  \url{https://www.wecc.biz/TransmissionExpansionPlanning/Pages/Datasets.aspx}.
}
\keyword{datasets}

