% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.compare_performance.R
\name{report.compare_performance}
\alias{report.compare_performance}
\alias{report_table.compare_performance}
\alias{report_statistics.compare_performance}
\alias{report_parameters.compare_performance}
\alias{report_text.compare_performance}
\title{Reporting models comparison}
\usage{
\method{report}{compare_performance}(x, ...)

\method{report_table}{compare_performance}(x, ...)

\method{report_statistics}{compare_performance}(x, table = NULL, ...)

\method{report_parameters}{compare_performance}(x, table = NULL, ...)

\method{report_text}{compare_performance}(x, table = NULL, ...)
}
\arguments{
\item{x}{Object of class \code{NEW OBJECT}.}

\item{...}{Arguments passed to or from other methods.}

\item{table}{Provide the output of  \code{report_table()} to avoid its
re-computation.}
}
\value{
An object of class \code{\link{report}}.
}
\description{
Create reports for model comparison as obtained by the
\code{\link[performance:compare_performance]{performance::compare_performance()}}
function in the \code{performance} package.
}
\examples{
\donttest{
library(report)
library(performance)

m1 <- lm(Sepal.Length ~ Petal.Length * Species, data = iris)
m2 <- lm(Sepal.Length ~ Petal.Length + Species, data = iris)
m3 <- lm(Sepal.Length ~ Petal.Length, data = iris)

x <- performance::compare_performance(m1, m2, m3)
r <- report(x)
r
summary(r)
as.data.frame(r)
summary(as.data.frame(r))

# Specific reports
report_table(x)
report_statistics(x)
report_parameters(x)
}
}
\seealso{
Specific components of reports (especially for stats models):
\itemize{
  \item \code{\link{report_table}}
  \item \code{\link{report_parameters}}
  \item \code{\link{report_statistics}}
  \item \code{\link{report_effectsize}}
  \item \code{\link{report_model}}
  \item \code{\link{report_priors}}
  \item \code{\link{report_random}}
  \item \code{\link{report_performance}}
  \item \code{\link{report_info}}
  \item \code{\link{report_text}}
}
Other types of reports:
\itemize{
  \item \code{\link{report_system}}
  \item \code{\link{report_packages}}
  \item \code{\link{report_participants}}
  \item \code{\link{report_sample}}
  \item \code{\link{report_date}}
}
Methods:
\itemize{
  \item \code{\link{as.report}}
}
Template file for supporting new models:
\itemize{
  \item \code{\link{report.default}}
}
}
