% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renameRestrictCols.R
\name{replyr_apply_f_mapped}
\alias{replyr_apply_f_mapped}
\title{Apply a function to a re-mapped data frame.}
\usage{
replyr_apply_f_mapped(d, f, nmap, ..., restrictMapIn = FALSE,
  rmap = replyr::replyr_reverseMap(nmap), restrictMapOut = FALSE)
}
\arguments{
\item{d}{data.frame to work on}

\item{f}{function to apply.}

\item{nmap}{named list mapping with keys specifying new column names, and values as original column names.}

\item{...}{force later arguments to bind by name}

\item{restrictMapIn}{logical if TRUE restrict columns when mapping in.}

\item{rmap}{reverse map (for after f is applied).}

\item{restrictMapOut}{logical if TRUE restrict columns when mapping out.}
}
\description{
Apply a function to a re-mapped data frame.
}
\examples{

# an external function with hard-coded column names
DecreaseRankColumnByOne <- function(d) {
  d$RankColumn <- d$RankColumn - 1
  d
}

# our example data, with different column names
d <- data.frame(Sepal_Length=c(5.8,5.7),
                Sepal_Width=c(4.0,4.4),
                Species='setosa',rank=c(1,2))
print(d)


# map our data to expected column names so we can use function
nmap <- c(GroupColumn='Species',
          ValueColumn='Sepal_Length',
          RankColumn='rank')
print(nmap)

dF <- replyr_apply_f_mapped(d, DecreaseRankColumnByOne, nmap)
print(dF)



}
\seealso{
\code{\link{let}}, \code{\link{replyr_reverseMap}}, \code{\link{replyr_mapRestrictCols}}
}
