% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ri.d}
\alias{ri.d}
\title{Creates a replication interval based on a published/sample Cohen's \emph{d}}
\usage{
ri.d(d, n1, n2, conf.level = 0.95, explain = FALSE,
  extended.output = FALSE)
}
\arguments{
\item{d}{A sample Cohen's \emph{d}-value (standardized mean difference) created with pooled variance denominator.}

\item{n1}{Sample size for group 1}

\item{n2}{Sample size for group 2}

\item{conf.level}{(optional 0 to 1 value) Confidence level desired (0 to 1). If not specified .95 (i.e, 95 percent) will be used.}

\item{explain}{(optional boolean) Default is FALSE. If TRUE, text output explaining the interval is provided.}

\item{extended.output}{(optional boolean) Default is FALSE. If TRUE, additional details (e.g., confidence interval) provided in numeric return output.}
}
\value{
A list of values (\code{lower.replication.interval.d, upper.replication.interval.d}) containing the replication interval (and related statistics if requested with the \code{extended.output} argument).
}
\description{
Creates a replication interval based on a published/sample Cohen's \emph{d}
}
\examples{
ri.d(d=.65,n1=20,n2=20)
ri.d(d=.65,n1=20,n2=20,explain=TRUE)
}

