% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valReplacement.R
\name{replaceVals}
\alias{replaceVals}
\title{User-intended wrapper for single-file replacements}
\usage{
replaceVals(dir, ..., save = TRUE)
}
\arguments{
\item{dir}{Quoted character of length = 1L describing the path to the directory containing the data and associated
lookup file(s), with either forward or double backward slash and no end slash.}

\item{...}{Not used for default file names "data.csv", "lookup.csv". Otherwise, custom names including file extension,
within quotation marks, such as "<data_name>.csv", "<lookup_name>.csv", \emph{entered in this order}!.}

\item{save}{Logical, default TRUE: save results to \emph{dir}. FALSE: display only. See Note below.}
}
\value{
A one-run named list containing the updated data and multiple replacement counts. Also, csv file saved in the
same directory under the name \emph{updated_<data_name>\emph{using}<lookup_name>}.
}
\description{
The function sends the prepared data.tables to \link[=sReplace]{sReplace}, receives updated data, displays a
list of updated data and of counts of multiple replacements and saves the updated data to disk (see Details).
}
\details{
The workflow:
\subsection{Tasks}{

The function reads the data/lookup pair converting each file to "data.table" class, performs conformance checks
on associated lookup, removes uninvolved data columns and non-standard lookup columns. Upon return from
\link[=sReplace]{sReplace}, re-structures updated result in the original format, saves the updated data to \emph{dir}
and displays a one-run named list containing updated data along with counts of duplicated and/or missing values
replacements requests.
}

\subsection{Messages}{

The function displays messages and comments regarding the internal workflow. It is recommended reading these
messages/comments as first troubleshooting step since they are specific to each file pair and request type.
To suppress messages, wrap the function with \link[base:message]{suppressMessages}.
The vignette contains definitions of terms.
}
}
\section{Note}{

In examples, please leave the function argument \emph{save} to FALSE. Otherwise, copy all content of the
folder "extdata", found in package's root, into a directory on your machine. Use the absolute path
to this directory as \emph{dir} argument (vignette example).
}

\examples{

## Not run: datasets with default name "data.csv", "lookup.csv"

if (interactive()) {
 dir = system.file("extdata", package = "replacer")
 replaceVals(dir, save = FALSE)
 }

}
\keyword{data}
\keyword{datasets}
\keyword{manip}
\keyword{misc}
