\name{hmat_sim}
\alias{hmat_sim}
\docType{data}
\title{
Simulated data set - indicators of association status matrix 
}
\description{
A matrix of size 10000x3 of indicators of whether each z-score from \code{\link{zmat_sim}} belongs to a non-null hypothesis for the feature in the study (1) or to a null hypothesis for the feature in the study (0).  
}
\usage{data(hmat_sim)}
\format{
\code{hmat_sim} is a matrix of 10000 rows, each row a vector of the true association status from which the z-scores in the same row in \code{zmat_sim} was generated. Specifically, for a zero entry in hmat_sim the corresponding z-score in \code{zmat_sim} was generated from the standard normal distribution, and for a unit entry in hmat_sim the corresponding z-score in \code{zmat_sim} was generated from the normal distribution with mean 3 and variance one.
}
\examples{
#### use hmat_sim to generate the simulated z-scores:

data(hmat_sim)
m <- nrow(hmat_sim)
set.seed(12)
zmat_sim1  <- matrix(rnorm(n=3*m,mean=hmat_sim*3),nrow=m,ncol=3)
rm(m,H)

data(zmat_sim)
stopifnot(all.equal(zmat_sim1,zmat_sim))

#### hmat_sim was generated by the following code:

H <- hconfigs(n.studies= 3, n.association.status=2)
f <- c(0.895,0.005,0.005,0.02,0.005,0.02,0.02,0.03) # frequencies for the association status vectors
m = 10000 # number of tests in each study
hmat_sim1 <- matrix(rep(x = H, times = m*cbind(f,f,f)),ncol=3) 

data(hmat_sim)
stopifnot(all.equal(hmat_sim1,hmat_sim))

# the simulation design
cbind(H,f)  
sum(f)      # all sum to 1?
}
\keyword{datasets}
\keyword{Replicability}
\keyword{GWAS}

