% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miAnalyze.R
\name{miAnalyze}
\alias{miAnalyze}
\title{Takes multiply imputed datasets (as generated by the \code{extract_MIdata()} function)
and runs an analysis function on each of them.}
\usage{
miAnalyze(formula, family = NULL, data, pool = TRUE)
}
\arguments{
\item{formula}{a two sided model formula (see \code{\link[stats]{formula}}).}

\item{family}{only for \code{glm}: a description of the distribution and link
function to be used in the model. This can be a character string
naming a family function, a family function or the result of a
call to a family function. (For more details see below and
\code{\link[stats]{family}}.)}

\item{data}{the output object of \code{extract_MIdata()} function.}

\item{pool}{logical. If TRUE, estimates from each imputed data set will be
pooled together according to Rubin's rules. Default is TRUE.}
}
\value{
A list containing
\itemize{
\item list of estimated coefficients and standard error from each imputed data.
\item pooled estimates based Rubin's rule if \code{pool = TRUE}.
}
}
\description{
Takes multiply imputed datasets (as generated by the \code{extract_MIdata()} function)
and runs an analysis function on each of them.
}
\details{
\code{rubin_rules} applies Rubin's rules (Rubin, 1987) for pooling together
the results from a multiple imputation procedure. The pooled point \code{Estimate} is
is the average across the point estimates from the complete-data analyses.
The \code{SE} is the square-root of the sum of two terms representing the within-variance
and the between-variance (see Little-Rubin (2002)). The function also returns
95\% confidence interval, based on the estimated pooled degrees of freedom
that can be used for inference based on the t-distribution.
}
