% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.reliabilitydiag}
\alias{plot.reliabilitydiag}
\alias{autoplot.reliabilitydiag}
\title{Plotting reliability diagram objects}
\usage{
\method{plot}{reliabilitydiag}(x, ...)

\method{autoplot}{reliabilitydiag}(
  object,
  ...,
  type = c("miscalibration", "discrimination"),
  colour = "red",
  params_histogram = NULL,
  params_ggMarginal = NULL,
  params_ribbon = NULL,
  params_diagonal = NULL,
  params_vsegment = NULL,
  params_hsegment = NULL,
  params_CEPline = NULL,
  params_CEPsegment = NULL,
  params_CEPpoint = NULL
)
}
\arguments{
\item{x}{an object inheriting from the class \code{'reliabilitydiag'}.}

\item{...}{further arguments to be passed to or from methods.}

\item{object}{an object inheriting from the class \code{'reliabilitydiag'}.}

\item{type}{one of \code{"miscalibration"}, \code{"discrimination"};
determines which
layers are added by default, including default parameter values.}

\item{colour}{a colour to be used to draw focus;
used for the CEP layers when \code{type} is \code{"miscalibration"},
and for the horizontal segment layer and CEP margin histogram
when \code{type} is \code{"discrimination"}.}

\item{params_histogram}{a list of arguments for
\code{ggplot2::geom_histogram};
this layer shows a histogram of the forecast values in the main plotting
region.}

\item{params_ggMarginal}{a list of arguments for \code{ggExtra::ggMarginal};
used to show the marginal distributions of the forecast values and
estimated CEP values by adding plots to the top and right of the main
plotting region. If this is anything other than \code{NA}, the \code{autoplot}
output cannot be customized by with additional layers.}

\item{params_ribbon}{a list of arguments for \code{ggplot2::geom_ribbon};
this layer shows the uncertainty quantification results.}

\item{params_diagonal}{a list of arguments for \code{ggplot2::geom_line};
this background layer illustrates perfect reliability.}

\item{params_vsegment}{a list of arguments for \code{ggplot2::geom_segment};
this layer shows a vertical segment illustrating the average forecast value.}

\item{params_hsegment}{a list of arguments for \code{ggplot2::geom_segment};
this layer shows a horizontal segment illustrating the average event frequency.}

\item{params_CEPline}{a list of arguments for \code{ggplot2::geom_line};
this layer shows a linear interpolation of the CEP estimates.}

\item{params_CEPsegment}{a list of arguments for
\code{ggplot2::geom_segment};
  this layer highlights the pieces where the CEP estimate remains constant.}

\item{params_CEPpoint}{a list of arguments for \code{ggplot2::geom_point};
this layer highlights the CEP estimate only for actually observed forecast values.}
}
\value{
An object inheriting from class \code{'ggplot'}.
}
\description{
Using the \pkg{ggplot2} package to visually diagnose the reliability of
prediction methods that issue probability forecasts.
}
\details{
\code{plot} always sends a plot to a graphics device, wheres \code{autoplot}
behaves as any \code{ggplot() + layer()} combination. That means, customized
plots should be created using \code{autoplot}.

Three sets of default parameter values are used:
\itemize{
\item If multiple predictions
  methods are compared, then only the most necessary information to determine
  reliability are displayed.
\item For a single prediction method and \code{type = "miscalibration"}, the
  focus lies on the deviation from the diagonal including uncertainty
  quantification.
\item For a single prediction method and \code{type = "discrimination"}, the
  focus lies on the PAV transformation and the resulting marginal distribution.
  A concentration of CEP values near 0 or 1 suggest a high potential predictive
  ability of a prediction method.
}

Setting any of the \code{params_*} arguments to \code{NA} disables that layer.

Default parameter values if \code{length(object) > 1}:
\tabular{ll}{
\code{params_histogram} \tab \code{NA} \cr
\code{params_ggMarginal} \tab \code{NA} \cr
\code{params_ribbon} \tab \code{NA} \cr
\code{params_diagonal} \tab \code{list(size = 0.3, colour = "black")} \cr
\code{params_vsegment} \tab \code{NA} \cr
\code{params_hsegment} \tab \code{NA} \cr
\code{params_CEPline} \tab \code{list(size = 0.2)} \cr
\code{params_CEPsegment} \tab \code{NA} \cr
\code{params_CEPpoint} \tab \code{NA}
}
Default parameter values for \code{type = "miscalibration"} if \code{length(object) == 1}:
\tabular{ll}{
\code{params_histogram} \tab \code{list(yscale = 0.2, colour = "black", fill = NA)} \cr
\code{params_ggMarginal} \tab \code{NA} \cr
\code{params_ribbon} \tab \code{list(fill = "blue", alpha = 0.15)} \cr
\code{params_diagonal} \tab \code{list(size = 0.3, colour = "black")} \cr
\code{params_vsegment} \tab \code{NA} \cr
\code{params_hsegment} \tab \code{NA} \cr
\code{params_CEPline} \tab \code{list(size = 0.2, colour = colour)} \cr
\code{params_CEPsegment} \tab \code{list(size = 2, colour = colour)} if \code{xtype == "continuous"}; \code{NA} otherwise. \cr
\code{params_CEPpoint} \tab \code{list(size = 2, colour = colour)} if \code{xtype == "discrete"}; \code{NA} otherwise.
}
Default parameter values for \code{type = "discrimination"} if \code{length(object) == 1}:
\tabular{ll}{
\code{params_histogram} \tab \code{NA} \cr
\code{params_ggMarginal} \tab \code{list(type = "histogram", xparams = list(bins = 100, fill = "grey"), yparams = list(bins = 100, fill = colour))} \cr
\code{params_ribbon} \tab \code{NA} \cr
\code{params_diagonal} \tab \code{list(size = 0.3, colour = "lightgrey")} \cr
\code{params_vsegment} \tab \code{list(size = 1.5, colour = "grey")} \cr
\code{params_hsegment} \tab \code{list(size = 1.5, colour = colour)} \cr
\code{params_CEPline} \tab \code{list(size = 0.2, colour = "black")} \cr
\code{params_CEPsegment} \tab \code{NA} \cr
\code{params_CEPpoint} \tab \code{list(colour = "black")}
}
}
\examples{
data("precip_Niamey_2016", package = "reliabilitydiag")
r <- reliabilitydiag(
  precip_Niamey_2016[c("Logistic", "EMOS", "ENS", "EPC")],
  y = precip_Niamey_2016$obs,
  region.level = NA
)

# simple plotting
plot(r)

# custom color scale for multiple prediction methods
cols <- c(Logistic = "red", EMOS = "blue", ENS = "darkgreen", EPC = "orange")
autoplot(r) +
  ggplot2::scale_color_manual(values = cols)

# default reliability diagram type with a title
rr <- reliabilitydiag(
  EMOS = precip_Niamey_2016$EMOS,
  r = r,
  region.level = 0.9
)
autoplot(rr) +
  ggplot2::ggtitle("Reliability diagram for EMOS method")

# using defaults for discrimination diagrams
p <- autoplot(r["EMOS"], type = "discrimination")
print(p, newpage = TRUE)

# ggMarginal needs to be called after adding all custom layers
p <- autoplot(r["EMOS"], type = "discrimination", params_ggMarginal = NA) +
  ggplot2::ggtitle("Discrimination diagram for EMOS method")
p <- ggExtra::ggMarginal(p, type = "histogram")
print(p, newpage = TRUE)

}
