% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VB_CS_FPCA.R
\name{vb_cs_fpca}
\alias{vb_cs_fpca}
\title{Cross-sectional FoSR using Variational Bayes and FPCA}
\usage{
vb_cs_fpca(formula, data = NULL, verbose = TRUE, Kt = 5, Kp = 2,
  alpha = 0.1, Aw = NULL, Bw = NULL, Apsi = NULL, Bpsi = NULL,
  argvals = NULL)
}
\arguments{
\item{formula}{a formula indicating the structure of the proposed model.}

\item{data}{an optional data frame, list or environment containing the 
variables in the model. If not found in data, the variables are taken from 
environment(formula), typically the environment from which the function is 
called.}

\item{verbose}{logical defaulting to \code{TRUE} -- should updates on progress be printed?}

\item{Kt}{number of spline basis functions used to estimate coefficient functions}

\item{Kp}{number of FPCA basis functions to be estimated}

\item{alpha}{tuning parameter balancing second-derivative penalty and
zeroth-derivative penalty (alpha = 0 is all second-derivative penalty)}

\item{Aw}{hyperparameter for inverse gamma controlling variance of spline terms
for population-level effects}

\item{Bw}{hyperparameter for inverse gamma controlling variance of spline terms
for population-level effects}

\item{Apsi}{hyperparameter for inverse gamma controlling variance of spline terms
for FPC effects}

\item{Bpsi}{hyperparameter for inverse gamma controlling variance of spline terms
for FPC effects}

\item{argvals}{not currently implemented}
}
\description{
Fitting function for function-on-scalar regression for cross-sectional data.
This function estimates model parameters using a VB and estimates
the residual covariance surface using FPCA.
}
\references{
Goldsmith, J., Kitago, T. (2016).
Assessing Systematic Effects of Stroke on Motor Control using Hierarchical 
Function-on-Scalar Regression. \emph{Journal of the Royal Statistical Society:
Series C}, 65 215-236.
}
\author{
Jeff Goldsmith \email{ajg2202@cumc.columbia.edu}
}
