% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lf_old.R
\name{lf_old}
\alias{lf_old}
\title{Construct an FLM regression term}
\usage{
lf_old(X, argvals = seq(0, 1, l = ncol(X)), xind = NULL,
  integration = c("simpson", "trapezoidal", "riemann"), L = NULL,
  splinepars = list(bs = "ps", k = min(ceiling(n/4), 40), m = c(2, 2)),
  presmooth = TRUE)
}
\arguments{
\item{X}{an \code{N} by \code{J=ncol(argvals)} matrix of function evaluations
\eqn{X_i(t_{i1}),., X_i(t_{iJ}); i=1,.,N.}}

\item{argvals}{matrix (or vector) of indices of evaluations of \eqn{X_i(t)}; i.e. a matrix with
\emph{i}th row \eqn{(t_{i1},.,t_{iJ})}}

\item{xind}{same as argvals. It will not be supported in the next version of refund.}

\item{integration}{method used for numerical integration. Defaults to \code{"simpson"}'s rule
for calculating entries in \code{L}. Alternatively and for non-equidistant grids,
\dQuote{\code{trapezoidal}} or \code{"riemann"}. \code{"riemann"} integration is always used if
\code{L} is specified}

\item{L}{an optional \code{N} by \code{ncol(argvals)} matrix giving the weights for the numerical
integration over \code{t}}

\item{splinepars}{optional arguments specifying options for representing and penalizing the
functional coefficient \eqn{\beta(t)}. Defaults to a cubic B-spline with second-order difference
penalties, i.e. \code{list(bs="ps", m=c(2, 1))} See \code{\link{te}} or \code{\link{s}} for details}

\item{presmooth}{logical; if true, the functional predictor is pre-smoothed prior to fitting.  See
\code{\link{smooth.basisPar}}}
}
\value{
a list with the following entries
\enumerate{
\item \code{call} - a \code{call} to \code{te} (or \code{s}, \code{t2}) using the appropriately
constructed covariate and weight matrices
\item \code{argvals} - the \code{argvals} argument supplied to \code{lf}
\item \code{L} - the  matrix of weights used for the integration
\item{xindname} - the name used for the functional predictor variable in the \code{formula}
used by \code{mgcv}
\item \code{tindname} - the name used for \code{argvals} variable in the \code{formula} used by \code{mgcv}
\item \code{LXname} - the name used for the \code{L} variable in the \code{formula} used by \code{mgcv}
\item \code{presmooth} - the \code{presmooth} argument supplied to \code{lf}
\item \code{Xfd} - an \code{fd} object from presmoothing the functional predictors using
\code{\link{smooth.basisPar}}.  Only present if \code{presmooth=TRUE}.  See \code{\link{fd}}
}
}
\description{
Defines a term \eqn{\int_{T}\beta(t)X_i(t)dt} for inclusion in an \code{\link[mgcv]{gam}}-formula
(or \code{\link{bam}} or \code{\link{gamm}} or \code{\link[gamm4]{gamm4}}) as constructed by
\code{\link{fgam}}, where \eqn{\beta(t)} is an unknown coefficient function and \eqn{X_i(t)}
is a functional predictor on the closed interval \eqn{T}. Defaults to a cubic B-spline with
second-order difference penalties for estimating \eqn{\beta(t)}.  The functional predictor must
be fully observed on a regular grid.
}
\seealso{
\code{\link{fgam}}, \code{\link{af}}, mgcv's \code{\link{linear.functional.terms}},
\code{\link{fgam}} for examples
}
\author{
Mathew W. McLean \email{mathew.w.mclean@gmail.com} and Fabian Scheipl
}
