% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Gibbs_Mult_FPCA.R
\name{gibbs_mult_fpca}
\alias{gibbs_mult_fpca}
\title{Multilevel FoSR using a Gibbs sampler and FPCA}
\usage{
gibbs_mult_fpca(formula, Kt = 5, Kp = 2, data = NULL, verbose = TRUE,
  N.iter = 5000, N.burn = 1000, sig2.me = 0.01, alpha = 0.1,
  SEED = NULL)
}
\arguments{
\item{formula}{a formula indicating the structure of the proposed model.}

\item{Kt}{number of spline basis functions used to estimate coefficient functions}

\item{Kp}{number of FPCA basis functions to be estimated}

\item{data}{an optional data frame, list or environment containing the
variables in the model. If not found in data, the variables are taken from
environment(formula), typically the environment from which the function is
called.}

\item{verbose}{logical defaulting to \code{TRUE} -- should updates on progress be printed?}

\item{N.iter}{number of iterations used in the Gibbs sampler}

\item{N.burn}{number of iterations discarded as burn-in}

\item{sig2.me}{starting value for measurement error variance}

\item{alpha}{tuning parameter balancing second-derivative penalty and
zeroth-derivative penalty (alpha = 0 is all second-derivative penalty)}

\item{SEED}{seed value to start the sampler; ensures reproducibility}
}
\description{
Fitting function for function-on-scalar regression for longitudinal data.
This function estimates model parameters using a Gibbs sampler and estimates
the residual covariance surface using FPCA.
}
\author{
Jeff Goldsmith \email{ajg2202@cumc.columbia.edu}
}
\references{
Goldsmith, J., Kitago, T. (Under Review).
Assessing Systematic Effects of Stroke on Motor Control using Hierarchical
Function-on-Scalar Regression.
}

