% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_mRNA2protein.R
\name{refseq_mRNA2protein}
\alias{refseq_mRNA2protein}
\title{Get the XP accession from XM accession}
\usage{
refseq_mRNA2protein(transcript)
}
\arguments{
\item{transcript}{A character string of the protein accession.}
}
\value{
A character vector containing the protein id encoded by the mRNA especified as \code{transcript}.
}
\description{
\code{refseq_mRNA2protein()} Returns the protein accession from a single transcript accession.

Depending on the function, available accessions in \code{refseqR} include RefSeq models with the prefixes XM_ (mRNA), XR_ (non-coding RNA), and XP_ (protein), as well as subsequently curated RefSeq records with NM_, NR_, or NP_ accession prefixes.
}
\examples{
 # Get the protein id from a single transcript accession
 transcript <- "XM_004487701"
 refseq_mRNA2protein(transcript)

 \donttest{
 # Get the protein ids from a set of transcript accessions
 transcript = c("XM_004487701", "XM_004488493")
 sapply(transcript, function(x) refseq_mRNA2protein(x), USE.NAMES = FALSE) }

}
\seealso{
\code{\link{refseq_protein2mRNA}} to obtain the transcript ids that encode a set of proteins ids.
}
\author{
Jose V. Die
}
