% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.bivRegion.R
\name{predict.bivRegion}
\alias{predict.bivRegion}
\title{Prediction for a bivRegion object}
\usage{
\method{predict}{bivRegion}(object, tau = 0.95, newdata = NULL, cond = FALSE, ...)
}
\arguments{
\item{object}{A bivRegion object.}

\item{tau}{A number or vector defining the desired coverage(s) of the
bivariate reference/probabilistic region.}

\item{newdata}{An optional data frame containing new covariate values, or
new observations.}

\item{cond}{A logical argument, if TRUE, a matrix of values defining the
conditional reference region limits is given.}

\item{...}{Additional prediction parameters.}
}
\value{
This function returns reference region limits values for
a given covariate value (if cond=TRUE), or which observations falls
outside the estimated region (if cond=FALSE).
}
\description{
This function takes a bivRegion object and allow to obtain region limits
for a given covariate value if cond=TRUE. If not, it can be applied
to a new dataset to evaluate which points will be included inside the
standarized region (for instance, if we estimate a reference region with
healthy patients results, we can know where non healthy patients will be located).
}
