% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_case_studies.R
\name{get_case_studies}
\alias{get_case_studies}
\title{Search and download case studies}
\usage{
get_case_studies(ID = NULL, UKPRN = NULL, UoA = NULL, tags = NULL,
  phrase = NULL)
}
\arguments{
\item{ID}{integer, can return multiple case studies if provided as a numeric
vector. If this argument is provided then all other arguments will be
ignored.}

\item{UKPRN}{integer, filter for a specific institution using its UKPRN.}

\item{UoA}{integer, filter for a specific Unit of Assessment.}

\item{tags}{integer, filter for specific tag IDs. Can combine multiple tags
if provided as a numeric vector. Multiple tags are combined with logical
AND.}

\item{phrase}{string, filter for a specific phrase. Currently only supports
single words.}
}
\value{
Returns a data_frame (from the \code{tibble} package).
}
\description{
This function uses the \code{SearchCaseStudies} method from the database API.
The method requires at least one filtering parameter, which means you need to
provide at least one argument to this function.
}
\details{
This function returns a data_frame (from the \code{tibble} package) as it
deals nicely with the nested data structures provided by the API. See the
example code below for a demonstration of this behaviour.
}
\examples{
\dontrun{
studies <- get_case_studies(ID = c(27,29))
studies
studies[1,"Continent"] # [] gives list element
studies[[1,"Continent"]] # [[]] gives contents
}


}

