% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_filter.R
\name{refdb_filter_seq_primer}
\alias{refdb_filter_seq_primer}
\title{Filter sequences based on the presence of primers.}
\usage{
refdb_filter_seq_primer(
  x,
  primer_forward = NULL,
  primer_reverse = NULL,
  max_error_forward = 0.1,
  max_error_reverse = 0.1
)
}
\arguments{
\item{x}{a reference database.}

\item{primer_forward}{forward primer.}

\item{primer_reverse}{reverse primer.}

\item{max_error_forward, max_error_reverse}{maximum error for match
(frequency base on primer length).}
}
\value{
A tibble (filtered reference database).
}
\description{
Filter sequences based on the presence of primers.
}
\examples{
lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
refdb_filter_seq_primer(lib, "ACTA")

}
