% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importMetaData.R
\name{importMetaData}
\alias{importMetaData}
\alias{importMetaData.redcapApiConnection}
\title{Import Meta Data (Data Dictionary) to a Project}
\usage{
importMetaData(rcon, data, ...)

\method{importMetaData}{redcapApiConnection}(
  rcon,
  data,
  refresh = TRUE,
  ...,
  field_types = REDCAP_METADATA_FIELDTYPE,
  validation_types = REDCAP_METADATA_VALIDATION_TYPE,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{a \code{redcapConnection} object.}

\item{data}{\code{data.frame} with the Meta Data to import.}

\item{...}{Additional arguments to pass to other methods.}

\item{refresh}{\code{logical(1)}. When \code{TRUE}, the cached metadata
and instruments will be refreshed after the import.}

\item{field_types}{\code{character} giving the acceptable field types
when validating the \code{field_type} column.}

\item{validation_types}{\code{character} giving the acceptable values 
for the \code{text_validation_or_show_slider_number} column.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{named \code{list}. Additional configuration parameters to pass to \code{httr::POST},
These are appended to any parameters in \code{rcon$config}}

\item{api_param}{named \code{list}. Additional API parameters to pass into the body of the
API call. This provides users to execute calls with options that may not
otherwise be supported by redcapAPI.}
}
\description{
This method allows you to import metadata (i.e., Data Dictionary) 
  into a project. Notice: Because of this method's destructive nature, 
  it is only available for use for projects in Development status.
}
\details{
Field names may start with a letter, have any number of letters, 
  numbers, or underscores, and end in either a letter or a number. All 
  letters must be lowercase (the function will coerce them to lower before
  checking for duplicate field names). 
  
Form names may start with a letter, have any number of letters, 
  numbers, or underscores, and end in either a letter or a number. All 
  letters must be lowercase (the function will coerce them to lower before
  checking for duplicate field names).
  
Field types may be one of \code{REDCAP_METADATA_FIELDTYPE}. In the event that a 
  new field type is added to REDCap and \code{redcapAPI} isn't yet updated, 
  you may add additional values via \code{c(REDCAP_METADATA_FIELDTYPE, "new_type")}.
  
Validation types may be one of \code{REDCAP_METADATA_VALIDATION_TYPE} or 
 \code{NA}. AS with field types, additional values can be appended if
 necessary. Only fields that have a field type of "text" or "slider" 
 should have a validation type. "slider" fields should be either \code{NA}
 (do not display the selected number) or \code{"number"}.
 
For multiple choice fields, the selection choices take the format of 
\code{"code1, label1 | ... | coden, labeln"}. For slider fields, the 
format is \code{"left_value | mid_value | right_value"}. Any of those 
values may be an empty character, but the two pipes are required, nonetheless.

For calculated fields, the values in \code{"select_choices_or_calculations"}
  are currently unvalidated.  

All of the values between brackets in the branching logic must be either a
field name or an existing unique event name (such as \code{"event_1_arm_1"})
}
