% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RecoSys.R
\name{output}
\alias{output}
\title{Outputing Factorization Matrices}
\arguments{
\item{r}{Object returned by \code{\link{Reco}()}.}

\item{out_P}{Filename of the output user score matrix. Note that this contains
the \strong{transpose} of the \eqn{P} matrix, hence each row in
the file stands for a user, and each column stands for a latent
factor. Values are space seperated. If \code{out_P} is an empty
string (\code{""}), the \eqn{P} matrix will not be output.}

\item{out_Q}{Filename of the output item score matrix. Note that this contains
             the \strong{transpose} of the \eqn{Q} matrix, hence each row in
             the file stands for an item, and each column stands for a latent
             factor. Values are space seperated. If \code{out_Q} is an empty
             string (\code{""}), the \eqn{Q} matrix will not be output. If both
             \code{out_P} and \code{out_Q} are \code{NULL}, this function will
             return a list containing the \eqn{P} and \eqn{Q} matrices in memory,
             and no files will be created.}
}
\description{
This method is a member function of class "\code{RecoSys}"
that could write the user score matrix \eqn{P} and item score matrix \eqn{Q}
to text files.

Prior to calling this method, model needs to be trained by calling
\code{$\link{train}()}.

The common usage of this method is
\preformatted{r = Reco()
r$output(out_P = file.path(tempdir(), "mat_P.txt"),
         out_Q = file.path(tempdir(), "mat_Q.txt"))}
}
\examples{
trainset = system.file("dat", "smalltrain.txt", package = "recosystem")
r = Reco()
set.seed(123) # This is a randomized algorithm
r$train(trainset, opts = list(dim = 10, nmf = TRUE))
P_path = tempfile()
Q_path = tempfile()

## Write P and Q matrices to files
r$output(P_path, Q_path)
head(read.table(P_path, header = FALSE, sep = " "))
head(read.table(Q_path, header = FALSE, sep = " "))

## Skip P and only output Q
r$output("", Q_path)

## Return P and Q in memory
res = r$output(NULL, NULL)
head(res$P)
head(res$Q)
}
\author{
Yixuan Qiu <\url{http://statr.me}>
}
\references{
W.-S. Chin, Y. Zhuang, Y.-C. Juan, and C.-J. Lin.
A Fast Parallel Stochastic Gradient Method for Matrix Factorization in Shared Memory Systems.
ACM TIST, 2015.

W.-S. Chin, Y. Zhuang, Y.-C. Juan, and C.-J. Lin.
A learning-rate schedule for stochastic gradient methods to matrix factorization.
PAKDD, 2015.
}
\seealso{
\code{$\link{train}()}, \code{$\link{predict}()}
}

