% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExecMetadata.R
\docType{methods}
\name{initialize,ExecMetadata-method}
\alias{initialize,ExecMetadata-method}
\alias{initialize-ExecMetadata}
\title{Initialize an execution metadata object}
\usage{
\S4method{initialize}{ExecMetadata}(.Object, executionId = as.character(NA),
  metadataId = as.character(NA), tag = as.character(NA),
  datapackageId = as.character(NA), user = as.character(NA),
  subject = as.character(NA), hostId = as.character(NA),
  startTime = as.character(NA), operatingSystem = as.character(NA),
  runtime = as.character(NA), moduleDependencies = as.character(NA),
  programName = as.character(NA), endTime = as.character(NA),
  errorMessage = as.character(NA), publishTime = as.character(NA),
  publishNodeId = as.character(NA), publishId = as.character(NA),
  console = FALSE, seq = as.integer(0))
}
\arguments{
\item{.Object}{The ExecMetada object}

\item{executionId}{a \code{"character"}, the unique identifier for an execution}

\item{metadataId}{a \code{"character"}, the unique identifier for the metadata object associated with an execution}

\item{tag}{A character vector that describes this execution.}

\item{datapackageId}{a \code{"character"}, the unique identifier for the datapackage associated with an execution}

\item{user}{a \code{"character"}, the user that started the execution}

\item{subject}{a \code{"character"}, the user identity that owns the uploaded execution datapackage}

\item{hostId}{a \code{"character"},  the host identifier that the execution datapackage was uploaded to}

\item{startTime}{a \code{"character"},  the starting time of the execution}

\item{operatingSystem}{a \code{"character"}, the operating system that the execution ran on}

\item{runtime}{a \code{"character"}, the software application used for the run, e.g. "R version 3.2.3 (2015-12-10)"}

\item{moduleDependencies}{a \code{"character"} vector, a list of modules loaded during an execution}

\item{programName}{a \code{"character"}, The name of the program that is being run.}

\item{endTime}{a \code{"character"}, the ending time of an execution}

\item{errorMessage}{a \code{"character"}, error messages generated during an execution}

\item{publishTime}{a \code{"character"}, the time of publication (uploading) of an execution package}

\item{publishNodeId}{a \code{"character"}, the node identifier that an execution package was published to}

\item{publishId}{a \code{"character"}, the unique identifier associated with a published execution}

\item{console}{a \code{"logical"}, was this execution recorded as commands typed at the console}

\item{seq}{an \code{"integer"}, an integer associated with an execution}
}
\description{
Initialize an execution metadata object
}
\seealso{
\code{\link[=ExecMetadata-class]{ExecMetadata}} { class description}
}

