% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDMC.R
\name{RDMC}
\alias{RDMC}
\alias{dRDMC}
\alias{pRDMC}
\alias{rRDMC}
\title{Revised Diffusion Model of Conflict Tasks}
\usage{
dRDMC(rt, resp, phi, x_res = "default", t_res = "default")

pRDMC(rt, resp, phi, x_res = "default", t_res = "default")

rRDMC(n, phi, dt = 1e-05)
}
\arguments{
\item{rt}{vector of response times}

\item{resp}{vector of responses ("upper" and "lower")}

\item{phi}{parameter vector in the following order:
\enumerate{
\item Non-decision time (\eqn{t_{nd}}). Time for non-decision processes such as stimulus
encoding and response execution. Total decision time t is the sum of the decision
and non-decision times.
\item Relative start (\eqn{w}). Sets the start point of accumulation as a ratio of
the two decision thresholds. Related to the absolute start z point via equation
\eqn{z = b_l + w*(b_u - b_l)}.
\item Automatic process amplitude (\eqn{A_0}). Max value of automatic process.
\item Attention shift parameter (\eqn{k}). Encodes congruency and thus differs between
congruent and incongruent trials.
\item Base drift rate of the automatic channel (\eqn{d_a}).
\item Base drift rate of the controlled channel (\eqn{d_c}).
\item Noise scale (\eqn{\sigma}). Model noise scale parameter.
\item Decision thresholds (\eqn{b}). Sets the location of each decision threshold. The
upper threshold \eqn{b_u} is above 0 and the lower threshold \eqn{b_l} is below 0 such that
\eqn{b_u = -b_l = b}. The threshold separation \eqn{a = 2b}.
\item Contamination (\eqn{g}). Sets the strength of the contamination process. Contamination
process is a uniform distribution \eqn{f_c(t)} where \eqn{f_c(t) = 1/(g_u-g_l)}
if \eqn{g_l <= t <= g_u} and \eqn{f_c(t) = 0} if \eqn{t < g_l} or \eqn{t > g_u}. It is
combined with PDF \eqn{f_i(t)} to give the final combined distribution
\eqn{f_{i,c}(t) = g*f_c(t) + (1-g)*f_i(t)}, which is then output by the program.
If \eqn{g = 0}, it just outputs \eqn{f_i(t)}.
\item Lower bound of contamination distribution (\eqn{g_l}). See parameter \eqn{g}.
\item Upper bound of contamination distribution (\eqn{g_u}). See parameter \eqn{g}.
}}

\item{x_res}{spatial/evidence resolution}

\item{t_res}{time resolution}

\item{n}{number of samples}

\item{dt}{step size of time. We recommend 0.00001 (1e-5)}
}
\value{
For the density a list of PDF values, log-PDF values, and the sum of the
log-PDFs, for the distribution function a list of of CDF values, log-CDF values,
and the sum of the log-CDFs, and for the random sampler a list of response
times (rt) and response thresholds (resp).
}
\description{
A DMC-like model which modifies the shape of the controlled and automatic processes
to ensure consistent stimulus representation across the task. It maintains all SDDM
parameters outside the drift rate which is \eqn{v(x,t) = w_a(t)*d_a + w_c(t)*d_c}, where
\eqn{w_a(t) = A_0*exp(-k*t)} and \eqn{w_c(t) = 1 - w_a(t)}.
}
\examples{
# Probability density function
dRDMC(rt = c(1.2, 0.6, 0.4), resp = c("upper", "lower", "lower"),
     phi = c(0.35, 0.5, 7.5, 40.0, 5.0, 5.0, 1.0, 0.5, 0.0, 0.0, 1.0))

# Cumulative distribution function
pRDMC(rt = c(1.2, 0.6, 0.4), resp = c("upper", "lower", "lower"),
     phi = c(0.35, 0.5, 7.5, 40.0, 5.0, 5.0, 1.0, 0.5, 0.0, 0.0, 1.0))

# Random sampling
rRDMC(n = 100, phi = c(0.35, 0.5, 7.5, 40.0, 5.0, 5.0, 1.0, 0.5, 0.0, 0.0, 1.0))
}
\references{
Lee, P.-S., & Sewell, D. K. (2023). A revised diffusion model for conflict tasks.
\emph{Psychonomic Bulletin & Review, 31}(1), 1–31.
}
\author{
Raphael Hartmann & Matthew Murrow
}
