% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_convert.R
\name{type_convert}
\alias{type_convert}
\title{Re-convert character columns in existing data frame}
\usage{
type_convert(df, col_types = NULL, na = c("", "NA"), trim_ws = TRUE,
  locale = default_locale())
}
\arguments{
\item{df}{A data frame.}

\item{col_types}{One of \code{NULL}, a \code{\link[=cols]{cols()}} specification, or
a string. See \code{vignette("readr")} for more details.

If \code{NULL}, column types will be imputed using all rows.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{trim_ws}{Should leading and trailing whitespace be trimmed from
each field before parsing it?}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}
}
\description{
This is useful if you need to do some manual munging - you can read the
columns in as character, clean it up with (e.g.) regular expressions and
then let readr take another stab at parsing it. The name is a homage to
the base \code{\link[utils]{type.convert}()}.
}
\examples{
df <- data.frame(
  x = as.character(runif(10)),
  y = as.character(sample(10)),
  stringsAsFactors = FALSE
)
str(df)
str(type_convert(df))

df <- data.frame(x = c("NA", "10"), stringsAsFactors = FALSE)
str(type_convert(df))

# Type convert can be used to infer types from an entire dataset

# first read the data as character
data <- read_csv(readr_example("mtcars.csv"),
                 col_types = cols(.default = col_character()))
str(data)
# Then convert it with type_convert
type_convert(data)
}
