% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/col_types.R
\name{col_types_standardise}
\alias{col_types_standardise}
\title{Standardise column types.}
\usage{
col_types_standardise(col_types, col_names, guessed_types)
}
\arguments{
\item{col_types}{One of \code{NULL}, a list, a named list or a string.

  If \code{NULL}, the column type will be imputed from the first 30 rows
  on the input. This is convenient (and fast), but not robust. If the
  imputation fails, you'll need to supply the correct types yourself.

  If a list, it must contain one "\code{\link{collector}}" for each column.
  If you only want to read a subset of the columns, you can use a named list
  (where the names give the column names). If a column is not mentioned by
  name, it will not be included in the output.

  Alternatively, you can use a compact string representation where each
  character represents one column: c = character, d = double, i = integer,
  l = logical and \code{_} skips the column.}

\item{col_names}{A character vector naming the columns.}

\item{rows}{A data frame containing the first few rows, parsed as
character vectors.}
}
\description{
Standardise column types.
}
\keyword{internal}

