test_that("Expected na behavior", {
    na_res <- read_ods('../testdata/na_test.ods', na = c("3", "999", "missing"))
    expect_true(is.na(na_res[4,1]))
    expect_true(is.na(na_res[4,2]))
    expect_true(is.na(na_res[3,3]))
    expect_true(is.na(na_res[4,3]))
})

test_that("type_convert honoring na #1, issue 78", {
    na_res <- read_ods('../testdata/na_test2.ods', na = c("one"))
    expect_true(is.na(na_res[1,1]))
    expect_false(is.na(na_res[2,1]))
    expect_false(is.na(na_res[3,1]))
    expect_false(is.na(na_res[4,1]))
    expect_false(is.na(na_res[5,1]))
    expect_false(is.na(na_res[6,1]))
    expect_false(is.na(na_res[7,1]))
    expect_false(is.na(na_res[8,1]))
    expect_false(is.na(na_res[9,1]))
    expect_false(is.na(na_res[10,1]))
    expect_equal((na_res[2,1]), "NaN")
    expect_equal((na_res[4,1]), "")
    expect_equal((na_res[6,1]), "NA")
    expect_equal((na_res[7,1]), "NA")
    expect_equal((na_res[8,1]), "")
})

test_that("type_convert honoring na #2, issue 78", {
    na_res <- read_ods('../testdata/na_test3.ods', na = c("one"))
    expect_true(is.na(na_res[1,1]))
    expect_false(is.na(na_res[2,1]))
    expect_false(any(is.na(na_res$ex1[2:9])))
    expect_false(any(is.na(na_res$ex2[1:9])))
    expect_true(any(is.na(na_res$ex3[1:9]))) ## due to col_types
    expect_false(any(is.na(na_res$ex4[1:9])))
    na_res <- read_ods('../testdata/na_test3.ods', na = c("one"), col_types = readr::cols(ex1 = "c", ex2 = "c", ex3 = "c", ex4 = "c"))
    expect_true(is.na(na_res[1,1]))
    expect_false(is.na(na_res[2,1]))
    expect_false(any(is.na(na_res$ex1[2:9])))
    expect_false(any(is.na(na_res$ex2[1:9])))
    expect_false(any(is.na(na_res$ex3[1:9])))
    expect_false(any(is.na(na_res$ex4[1:9])))
})
