telomere.F <- function(Feat, SQuali, SQualiN){
  Item <- c("/citation=", "/db_xref=", "/experiment=", "/inference=", "/note=","/rpt_type=", "/rpt_unit_range=", "/rpt_unit_seq=", "/standard_name=")
  ItemN <- c("citation", "db_xref", "experiment", "inference", "note","rpt_type", "rpt_unit_range", "rpt_unit_seq", "standard_name")
  Feat[length(Feat)] <- gsub("\\\",$", "", Feat[length(Feat)])
  telomere <- data.frame("Location" = "telomere", "Qualifier" = gsub(".*telomere +([^.]+)\"*", "\\1", Feat[1], perl = T), stringsAsFactors = F)
  for(i in 2:length(Feat)){
    for(j in 1:length(Item)){
      if(length(grep(Item[j], Feat[i], perl = T)) == 1){
        telomere <- rbind(telomere, c(ItemN[j],  gsub(".*=([^.]+)\"*", "\\1", Feat[i])))
        if((length(grep("\\\\\"$|\"\\\", $|\\d$", Feat[i])) == 0 & i != length(Feat)) == T){
          t <- i+1
          while(length(grep("\\\\\"$|\"\\\", $|\\d$", Feat[t])) == 0 && t <= length(Feat)){
            telomere[dim(telomere)[1],2] <- paste(telomere[dim(telomere)[1],2], gsub("\\s", " ", Feat[t]), sep = " ")
            t <- t+1
          }
          if(length(grep("\\\\\"$|\"\\\", $|\\d$", Feat[t])) == 1){
            telomere[dim(telomere)[1],2] <- paste(telomere[dim(telomere)[1],2], gsub("\\s", " ", Feat[t]), sep = " ")
          }
        }
      }
    }
    for(k in 1:length(SQuali)){
      if(length(grep(SQuali[k], Feat[i], perl = T)) == 1){
        telomere <- rbind(telomere, c(SQuali[k], SQualiN[k]))
      }
    }
  }
  telomere <- apply(telomere, 2, function(x){gsub(" {2,}", " ", x, perl = TRUE)})
  telomere <- apply(telomere, 2, function(x){gsub("\"", "", x, fixed = T)})
  telomere <- apply(telomere, 2, function(x){gsub("\\", "", x, fixed = T)})
  telomere <- apply(telomere, 2, function(x){gsub("[^[:alnum:][:space:][]'.,:_<>()-]", "", x, perl = TRUE)})
  return(telomere)
}
