% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renderReactLog.R, R/showReactLog.R
\name{reactlog_render}
\alias{reactlog_render}
\alias{reactlog_show}
\title{Reactive Log Visualizer}
\usage{
reactlog_render(log, session_token = NULL, time = TRUE)

reactlog_show(log, time = TRUE, ...)
}
\arguments{
\item{log}{Log produced by shiny to be processed}

\item{session_token}{token to be used to subset which session is displayed.  Defaults to all sessions.}

\item{time}{A boolean that specifies whether or not to display the
time that each reactive takes to calculate a result.}

\item{...}{Future parameter expansion. Currently ignored}
}
\description{
Provides an interactive browser-based tool for visualizing reactive
dependencies and execution in your application.
}
\details{
To use the reactive log visualizer, start with a fresh R session and
run the command \code{options(shiny.reactlog=TRUE)}; then launch your
application in the usual way (e.g. using \code{\link[shiny]{runApp}}). At
any time you can hit \preformatted{Ctrl+F3} (or for Mac users, \preformatted{Cmd+F3}) in your
web browser to launch the reactive log visualization.

The reactive log visualization only includes reactive activity up
until the time the report was loaded. If you want to see more recent
activity, refresh the browser.

Note that Shiny does not distinguish between reactive dependencies
that "belong" to one Shiny user session versus another, so the
visualization will include all reactive activity that has taken place
in the process, not just for a particular application or session.

As an alternative to pressing \preformatted{Ctrl/Cmd+F3}--for example, if you
are using reactives outside of the context of a Shiny
application--you can run the \code{showReactLog} function, which will
generate the reactive log visualization as a static HTML file and
launch it in your default browser. In this case, refreshing your
browser will not load new activity into the report; you will need to
call \code{showReactLog()} explicitly.

For security and performance reasons, do not enable
\code{shiny.reactlog} in production environments. When the option is
enabled, it's possible for any user of your app to see at least some
of the source code of your reactive expressions and observers.
}
\examples{

\dontrun{
library(shiny)
library(reactlog)

# tell shiny to log reactivity
options("shiny.reactlog" = TRUE)

# run a shiny app
app <- system.file("examples/01_hello", package = "shiny")
runApp(app)

# once app has closed, display reactlog
shiny::showReactLog()
}
}
\seealso{
\code{shiny::\link[shiny]{showReactLog}}
}
