% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_search.R
\name{drop_search}
\alias{drop_search}
\title{Returns metadata for all files and folders whose filename contains the given
search string as a substring.}
\usage{
drop_search(
  query,
  path = "",
  start = 0,
  max_results = 100,
  mode = "filename",
  dtoken = get_dropbox_token()
)
}
\arguments{
\item{query}{The search string. This string is split (on spaces) into
individual words. Files and folders will be returned if they contain all
words in the search string.}

\item{path}{Path in the user's Dropbox, relative to root}

\item{start}{The starting index within the search results (used for paging).
The default for this field is 0}

\item{max_results}{The maximum number of search results to return. The default
for this field is 100.}

\item{mode}{Mode can take the option of filename, filename_and_content, or search deleted files with deleted_filename}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}. rdrop2
will try to automatically locate your local credential cache and use them.
However, if the credentials are not found, the function will initiate a new
authentication request. You can override this in \code{\link{drop_auth}} by
pointing to a different location where your credentials are stored.}
}
\description{
Returns metadata for all files and folders whose filename contains the given
search string as a substring.
}
\examples{
\dontrun{
# If you know me, you know why this query exists
drop_search('gif') \%>\% select(path, is_dir, mime_type)
}
}
\references{
\href{https://www.dropbox.com/developers/documentation/http/documentation#files-search}{API documentation}
}
