% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/drop_file_ops.R
\name{drop_exists}
\alias{drop_exists}
\title{Checks to see if a file/folder exists on Dropbox}
\usage{
drop_exists(path = NULL)
}
\arguments{
\item{path}{The full path to a Dropbox file}
}
\description{
Since many file operations such as move, copy, delete and history can only act
on files that currently exist on a Dropbox store, checking to see if the
\code{path} is valid before operating prevents bad API calls from being sent
to the server. This functions returns a logical response after checking if a
file path is valid on Dropbox.
}
\examples{
\dontrun{
drop_create("existential_test")
drop_exists("existential_test")
drop_delete("existential_test")
}
}

