% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phy_abundance.R
\name{phy_abundance}
\alias{phy_abundance}
\title{Calculate abundance of historical species}
\usage{
phy_abundance(partition, structure_matrix)
}
\arguments{
\item{partition}{two-dimensional \code{matrix} of mode \code{numeric} with
rows as types, columns as subcommunities, and elements containing relative
abundances of types in subcommunities. In the case of phylogenetic
metacommunities, these are the relative abundances of terminal taxa.}

\item{structure_matrix}{\code{output$structure} of \code{phy_struct()}.}
}
\description{
Calculates the relative abundance of historical species.
}
\examples{
tree <- ape::rtree(n = 5)
tree$tip.label <- paste0("sp", seq_along(tree$tip.label))
partition <- cbind(a = c(1,1,1,0,0), b = c(0,1,0,1,1))
row.names(partition) <- tree$tip.label
partition <- partition / sum(partition)
partition <- partition[sample(1:nrow(partition)),]
ps <- phy_struct(tree, partition)
structure_matrix <- ps$structure
phy_abundance(partition, structure_matrix)

}
