% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smatrix.R
\name{smatrix}
\alias{smatrix}
\title{Phylogenetic similarity matrix (ultrametric)}
\usage{
smatrix(ps)
}
\arguments{
\item{ps}{\code{phy_struct()} output.}
}
\value{
Returns an \eqn{hS x hS} matrix; pair-wise similarity of historic 
species.
}
\description{
Function to calculate an ultrametric-similarity matrix.
}
\examples{
tree <- ape::rtree(n = 5)
tree$tip.label <- paste0("sp", seq_along(tree$tip.label))
partition <- cbind(a = c(1,1,1,0,0), b = c(0,1,0,1,1))
row.names(partition) <- tree$tip.label
partition <- partition / sum(partition)

ps <- phy_struct(tree, partition)
smatrix(ps)

}
