% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReportService.R
\name{dfp_getSavedQueriesByStatement}
\alias{dfp_getSavedQueriesByStatement}
\title{getSavedQueriesByStatement}
\usage{
dfp_getSavedQueriesByStatement(request_data, as_df = FALSE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getSavedQueriesByStatementResponse
}
\description{
Retrieves a page of the saved queries either created by or shared with the current user. Each SavedQuery in the page, if it is compatible with the current API version, will contain a ReportQuery object which can be optionally modified and used to create a ReportJob. This can then be passed to ReportService runReportJob. The following fields are supported for filtering: 
\itemize{
  \item{id}
  \item{name}
}
}
\examples{
\dontrun{
request_data <- list(filterStatement=list(query="WHERE id = 936165016"))
this_result <- dfp_getSavedQueriesByStatement(request_data)
this_report_query <- this_result$reportQuery

# resubmit the report job with the saved query
report_data <- list(reportJob=list(reportQuery = this_report_query))
report_data <- dfp_full_report_wrapper(report_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/ReportService#getSavedQueriesByStatement}{Google Documentation for getSavedQueriesByStatement}
}
