% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CustomTargetingService.R
\name{dfp_getCustomTargetingValuesByStatement}
\alias{dfp_getCustomTargetingValuesByStatement}
\title{getCustomTargetingValuesByStatement}
\usage{
dfp_getCustomTargetingValuesByStatement(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getCustomTargetingValuesByStatementResponse
}
\description{
Gets a CustomTargetingValuePage of CustomTargetingValue objects that satisfy the given Statement query.  The WHERE clause in the Statement query must always contain CustomTargetingValue customTargetingKeyId as one of its columns in a way that it is AND'ed with the rest of the query. So, if you want to retrieve values for a known set of key ids, valid Statement query would look like:    "WHERE customTargetingKeyId IN ('17','18','19')" retrieves all values that are associated with keys having ids 17, 18, 19.   "WHERE customTargetingKeyId = '17' AND name = 'red'" retrieves values that are associated with keys having id 17 and value name is 'red'.     The following fields are supported for filtering: 
\itemize{
  \item{id}
  \item{customTargetingKeyId}
  \item{name}
  \item{displayName}
  \item{matchType}
}
}
\examples{
\dontrun{
 dat <- list(filterStatement=list('query'="WHERE status='ACTIVE'")) 
 res <- dfp_getCustomTargetingValuesByStatement(dat)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/CustomTargetingService#getCustomTargetingValuesByStatement}{Google Documentation for getCustomTargetingValuesByStatement}
}
