% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForecastService.R
\name{dfp_getAvailabilityForecast}
\alias{dfp_getAvailabilityForecast}
\title{ForecastService}
\usage{
dfp_getAvailabilityForecast(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getAvailabilityForecastResponse
}
\description{
Provides methods for estimating traffic (clicks/impressions) for line
items. Forecasts can be provided for LineItem objects that exist in the
system or which have not had an ID set yet.
}
\details{
Test Network Behavior

Test networks are unable to provide forecasts that would be comparable 
to the production environment because forecasts require traffic history. 
Visit the See Also section below to proceed to Google and review the details.'

getAvailabilityForecast

Gets the availability forecast for a ProspectiveLineItem. 
An availability forecast reports the maximum number of available 
units that the line item can book, and the total number of units 
matching the line item's targeting.
}
\examples{
\dontrun{
filter <- "WHERE Status='DELIVERING' LIMIT 1"
one_li <- dfp_getLineItemsByStatement(list(filterStatement=list(query=filter)))[[1]]
hypothetical_line_item <- list(lineItem=
                               list(id=one_li$id,
                                    startDateTime=one_li$startDateTime,
                                    endDateTime=dfp_date_to_list(Sys.Date()+100),
                                    lineItemType=one_li$lineItemType,
                                    costType=one_li$costType, 
                                    primaryGoal=one_li$primaryGoal, 
                                    targeting=one_li$targeting))
request_data <- list(lineItem=hypothetical_line_item,
                     forecastOptions=list(includeTargetingCriteriaBreakdown='true', 
                                          includeContendingLineItems='true'))
dfp_getAvailabilityForecast_result <- dfp_getAvailabilityForecast(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/ForecastService#getAvailabilityForecast}{Google Documentation for getAvailabilityForecast}
}
